/************************************************************************************
* Application Parameters Configuration 
*
* (c) Copyright 2010, Freescale, Inc.  All rights reserved.
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale.
*
************************************************************************************/

#ifndef __SMAC_APPLICATION_CONF_H__
#define __SMAC_APPLICATION_CONF_H__

#include "EmbeddedTypes.h"          /*Include special data types*/             
#include "Utilities_Interface.h"    /*Includes Generic utilities*/
#include "SMAC_Interface.h"         /*Include all SMAC OTA functionality*/
#include "Interrupt.h"
#include "PortConfig.h"
#include "TransceiverDrv.h"
#include "TransceiverReg.h"
#include "Phy.h"
#include "LED.h"
#include "wdog.h"
#include "LED.h"                    /*Include all LED functionality*/
#include "Uart_Interface.h"         /*Include all UART functionality*/
#include "TMR_Interface.h"          /*Include all Timer functionality*/
#include "UartUtil.h"               /*Include all UART functionality*/
#include "Uart.h"
#include "main.h"


/* Simple Range Demo_Configuration Parameters Definition_Start */ 

#define gFreqBand_c                     gSMAC_902_928MHz_c
#define gPowerAmplifier_c               gDisablePA_Boost_c
#ifdef MKW01_NA
//#define gDefaultOutputPower             (0x11)                                //-1dBm for PA0 and PA1. Default settings for NA region.
#define gDefaultOutputPower             (0x1F)                                  //For the purpose of the Range Demonstration this is left at max output power. 13dBm for PA0 and PA1
#endif
#ifdef MKW01_EU
#define gDefaultOutputPower             (0x1F)                                  //13dBm for PA0 and PA1
#endif
#define gDeviceType_c       gRxNode_c		//gRxNode_c 
//#define gDeviceType_c       gTxNode_c		//gTxNode_c 
//#define gSimpleRangePayloadLength_c 8		//27		//Hi there		(Use 8 for Rx "Hi there", Use 27 for Tx)
#define gSimpleRangePayloadLength_c 27		//8
#define gDelayBetweenPacketsInMs_c      100                                     //10

/* Simple Range Demo_Configuration Parameters Definition_End */

/* Default Radio Registers Values_Start */
#define gDefaultOperationMode_c		( OpMode_StandBy )
#ifdef MKW01_NA
#if (CARRIER_FREQ == 315)
#define gDefaultRfFreq_c		( 0x4EC000 ) 
#elif (CARRIER_FREQ == 434)
#define gDefaultRfFreq_c		( 0x6C7FFB )
#elif (CARRIER_FREQ == 915)
#define gDefaultRfFreq_c		( 0xE4C000 )                            //rf freq 915 MHz (US).
#endif // CARRIER_FREQ
#endif
#ifdef MKW01_EU
#if (CARRIER_FREQ == 315)
#define gDefaultRfFreq_c		( 0x4EC000 ) 
#elif (CARRIER_FREQ == 434)
#define gDefaultRfFreq_c		( 0x6C7FFB )
#else
#define gDefaultRfFreq_c		( 0xD8A199 )                            //rf freq 866.525 MHz (EU).
#endif // CARRIER_FREQ
#endif
//#define gDefaultBitRate_c		( 0x0280 )                              //50000 bps
//#define gDefaultBitRate_c		( 0x0D05 )                              //9600
#define gDefaultBitRate_c		( 0x0680 )                              //19230
//#define gDefaultFreqDv_c		( 0x0199 )                              //25000 Hz
#define gDefaultFreqDv_c		( 0x0333 )
#define gDefaultSequencer_c		( OpMode_Sequencer_On )
#define gDefaultDataMode_c		( DataModul_DataMode_Packet )
#define gDefaultModulationType_c	( DataModul_Modulation_Fsk )
//#define gDefaultModulationShaping_c	( DataModul_ModulationShaping_NoShaping )       
#define gDefaultModulationShaping_c	( DataModul_ModulationShaping_BT_1 )    
#define gDefaultPowerAmpMode_c		( PaLevel_Pa0_On )
#define gDefaultPaRamp_c		( 0x09 )         
#define gDefaultDccFreq_c		( DccFreq_7 )                                           
#define gDefaultRxFilterBw_c		( RxBw_83300 )                                                  
#define gDefaultDccFreqAfc_c		( DccFreq_5 )                                            
#define gDefaultRxFilterBwAfc_c		( RxBw_100000 )                         
#define gDefaultOokThresType_c		( OokThreshType_Peak )
#define gDefaultOokFixedThres_c		( 0x06 )
#define gDefaultOokPeakThresStep_c	( OokPeakThreshStep_0_5dB )
#define gDefaultOokPeakThresDec_c	( OokPeakThreshDec_OncePerChip )
#define gDefaultOokAvgThreshFilt_c	( OokAvgThreshFilt_382 )
#define gDefaultAfcLowBeta_c		( FALSE )
#define gDefaultLowBetaOffset_c		( 0x00 )
#define gDefaultAfcAutoClear_c		( FALSE )
#define gDefaultAfcAuto_c		( FALSE )
#define gDefaultRxTimeout_c 		( 0x00 )
#define gDefaultRxTimeoutThresh_c	( 0x00 )
#define gDefaultRssiThresh_c		( 0xFF )
#define gDefaultLnaImputImpedance_c	( Lna_LnaZin_200 )
#define gDefaultSensitivityBoost_c	( NormalSensitivity )
#define gDefaultLnaGain_c		( 0x88 ) 
#define gDefaultFifoThresh_c            ( 0x8F ) 
#define gDefaultSyncValue_c             ( 0x01 ) 
//#define gDefaultPreambleLength_c	( 1 )
#define gDefaultPreambleLength_c	( 3 )
//#define gDefaultSyncWordSize_c		( SyncConfig_SyncSize_2 )
#define gDefaultSyncWordSize_c		( SyncConfig_SyncSize_4 )                          
#define gPrbs9BufferLength_c		( 65 )
#define gReset_c 			( 'R' )
/* Default Radio Registers Values_End */

#endif /* __SMAC_APP_CONFIG_H__ */

